/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei;

import dev.architectury.fluid.FluidStack;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.rei.AlloyDisplay;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.widgets.ArrowWidget;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeCategory
implements TinkersCategory<AlloyDisplay> {
    private static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/alloy.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "alloy.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final IRecipeTooltipReplacement FLUID_TOOLTIP = (slot, list) -> {
        if (slot.getCurrentEntry().getType() == VanillaEntryTypes.FLUID) {
            FluidTooltipHandler.appendMaterial(TinkersCategory.fromREIFluid((FluidStack)slot.getCurrentEntry().castValue()), list);
        }
    };
    public static final IRecipeTooltipReplacement FUEL_TOOLTIP = (slot, tooltip) -> {
        if (slot.getCurrentEntry().getType() == VanillaEntryTypes.FLUID) {
            MeltingFuelHandler.getTemperature(((FluidStack)slot.getCurrentEntry().castValue()).getFluid()).ifPresent(temperature -> tooltip.add(class_2561.method_43469((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature}).method_27692(class_124.field_1080)));
        }
    };
    private final WidgetHolder background = new WidgetHolder(BACKGROUND_LOC, 0, 0, 172, 62);
    private final Renderer icon = EntryStacks.of((class_1799)new class_1799(TinkerSmeltery.smelteryController));
    private final WidgetHolder tank = new WidgetHolder(BACKGROUND_LOC, 172, 17, 16, 16);

    public CategoryIdentifier<AlloyDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.ALLOY;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public void draw(AlloyDisplay display, class_332 graphics, double mouseX, double mouseY) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        String tempString = class_1074.method_4662((String)KEY_TEMPERATURE, (Object[])new Object[]{display.getTemperature()});
        int x = 102 - fontRenderer.method_1727(tempString) / 2;
        graphics.method_51433(fontRenderer, tempString, x, 5, Color.GRAY.getRGB(), false);
    }

    public static long drawVariableFluids(List<Widget> widgets, boolean isInput, int x, int y, Point origin, int totalWidth, int height, List<List<io.github.fabricators_of_create.porting_lib.fluids.FluidStack>> fluids, long minAmount, IRecipeTooltipReplacement tooltip) {
        int count = fluids.size();
        long maxAmount = minAmount;
        if (count > 0) {
            for (List<io.github.fabricators_of_create.porting_lib.fluids.FluidStack> list : fluids) {
                for (io.github.fabricators_of_create.porting_lib.fluids.FluidStack input : list) {
                    if (input.getAmount() <= maxAmount) continue;
                    maxAmount = input.getAmount();
                }
            }
            int w = totalWidth / count;
            int max = count - 1;
            for (int i = 0; i < max; ++i) {
                int fluidX = x + i * w;
                Slot slot = TinkersCategory.slot(fluidX, y, origin, isInput).disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(fluids.get(i))));
                long finalMaxAmount = maxAmount;
                slot.getEntries().forEach(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)entryStack.cast(), (float)((float)((FluidStack)entryStack.castValue()).getAmount() / (float)finalMaxAmount)));
                slot.getBounds().setSize(w + 2, height + 2);
                TinkersCategory.setEntryTooltip(slot, tooltip);
                widgets.add((Widget)slot);
            }
            int fluidX = x + max * w;
            Slot slot = TinkersCategory.slot(fluidX, y, origin, isInput).disableBackground().entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(fluids.get(max))));
            long finalMaxAmount1 = maxAmount;
            slot.getEntries().forEach(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)entryStack.cast(), (float)((float)((FluidStack)entryStack.castValue()).getAmount() / (float)finalMaxAmount1)));
            slot.getBounds().setSize(totalWidth - w * max + 2, height + 2);
            TinkersCategory.setEntryTooltip(slot, tooltip);
            widgets.add((Widget)slot);
        }
        return maxAmount;
    }

    @Override
    public void addWidgets(AlloyDisplay display, List<Widget> widgets, Point origin, Rectangle bounds) {
        long maxAmount = AlloyRecipeCategory.drawVariableFluids(widgets, true, 19, 11, origin, 48, 32, display.getRecipe().getDisplayInputs(), display.getRecipe().getOutput().getAmount(), FLUID_TOOLTIP);
        Slot output = this.slot(137, 11, origin).markOutput().entries((Collection)display.getOutputEntries().get(0));
        output.getEntries().forEach(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)output.getCurrentEntry().cast(), (float)((float)((FluidStack)entryStack.castValue()).getAmount() / (float)maxAmount)));
        TinkersCategory.setEntryTooltip(output, FLUID_TOOLTIP);
        output.getBounds().setSize(18, 34);
        widgets.add((Widget)output);
        Slot renderSlot = this.slot(94, 43, origin).entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(MeltingFuelHandler.getUsableFuels(display.getTemperature()))));
        TinkersCategory.setEntryTooltip(renderSlot, FUEL_TOOLTIP);
        renderSlot.getBounds().setSize(18, 18);
        widgets.add((Widget)renderSlot);
        widgets.add(this.tank.build(94, 43, origin));
        widgets.add((Widget)new ArrowWidget(this.point(90, 21, origin), BACKGROUND_LOC, 172, 0).animationDurationTicks(200.0));
    }

    @Override
    public WidgetHolder getBackground() {
        return this.background;
    }

    public Renderer getIcon() {
        return this.icon;
    }
}

